<?php
/**
 * Plugin Name: Well Themes: Social Connect
 * Plugin URI: http://wellthemes.com/
 * Description: This widget displays the social links.
 * Version: 1.0
 * Author: Well Themes Team
 * Author URI: http://wellthemes.com/
 *
 */

/**
 * Add function to widgets_init that'll load our widget.
 */
add_action( 'widgets_init', 'wellthemes_connect_widgets' );

function wellthemes_connect_widgets() {
	register_widget( 'wellthemes_connect_widget' );
}

/**
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update.  Nice!
 *
 */
class wellthemes_connect_widget extends WP_Widget {

	/**
	 * Widget setup.
	 */
	function wellthemes_connect_widget() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'widget_connect', 'description' => __('Displays the social links.', 'wellthemes') );

		/* Create the widget. */
		$this->WP_Widget( 'wellthemes_connect_widget', __('تابعونا على', 'wellthemes'), $widget_ops);
	}

	/**
	 * display the widget on the screen.
	 */
	function widget( $args, $instance ) {
		
		extract( $args );
		
		/* Our variables from the widget settings. */
		
		
		$twitter_title = $instance['twitter_title'];
		$facebook_title = $instance['facebook_title'];
		$gplus_title = $instance['gplus_title'];
		$youtube_title = $instance['youtube_title'];
		$rss_title = $instance['rss_title'];
		
		$twitter_url = $instance['twitter_url'];
		$facebook_url = $instance['facebook_url'];
		$gplus_url = $instance['gplus_url'];
		$youtube_url = $instance['youtube_url'];
		$rss_url = $instance['rss_url'];
		
		
  
       ?>
	    	   
	   <div class="links-wrap">
		   <ul class="list">
			   <?php if(!empty($twitter_url)){	?>
					<div class="twitter"><a class="twitter" href="<?php echo $twitter_url; ?>" target="_blank"><?php echo $twitter_title; ?></a></div>
				<?php } 
				
				if(!empty($facebook_url)){	?>
					<div class="fb"><a class="fb" href="<?php echo $facebook_url; ?>" target="_blank"><?php echo $facebook_title; ?></a></div>
				<?php }
				
				if(!empty($gplus_url)){	?>
					<div class="gplus"><a class="gplus" href="<?php echo $gplus_url; ?>" target="_blank"><?php echo $gplus_title; ?></a>
					</div>
				<?php }
				
				if(!empty($youtube_url)){	?>
					<div class="youtube"><a class="youtube" href="<?php echo $youtube_url; ?>" target="_blank"><?php echo $youtube_title; ?></a></div>
				<?php }
				
				if(!empty($rss_url)){	?>
					<div class="rss"><a class="rss" href="<?php echo $rss_url; ?>" target="_blank"><?php echo $rss_title; ?></a></div>
				<?php }	 ?>
				
			</ul>
		</div>		
	   <?php
		
		/* After widget (defined by themes). */
		echo $after_widget;
	}

	/**
	 * Displays the widget settings controls on the widget panel.
	 * Make use of the get_field_id() and get_field_name() function
	 * when creating your form elements. This handles the confusing stuff.
	 */
	function form( $instance ) {
 
		/* Set up some default widget settings. */
		$defaults = array(			
			'twitter_title' => 'تابعونا على تويتر',
			'facebook_title' => 'تابعونا على فيس بوك',
			'gplus_title' => 'تابعونا على جوجل بلس',
			'youtube_title' => 'اشترك فى قناه يوتيوب',
			'rss_title' => 'اشترك ليصلك آخر المقالات',			
			'twitter_url' => '',
			'facebook_url' => '',
			'gplus_url' => '',
			'youtube_url' => '',
			'rss_url' => '',
		);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		
		
		<p>
			<label for="<?php echo $this->get_field_id('twitter_title'); ?>"><?php _e('Twitter Title:', 'wellthemes') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('twitter_title'); ?>" name="<?php echo $this->get_field_name('twitter_title'); ?>" type="text" value="<?php echo $instance['twitter_title']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'twitter_url' ); ?>"><?php _e('Twitter URL:', 'wellthemes') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'twitter_url' ); ?>" name="<?php echo $this->get_field_name( 'twitter_url' ); ?>" value="<?php echo $instance['twitter_url']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('facebook_title'); ?>"><?php _e('Facebook Title:', 'wellthemes') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('facebook_title'); ?>" name="<?php echo $this->get_field_name('facebook_title'); ?>" type="text" value="<?php echo $instance['facebook_title']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'facebook_url' ); ?>"><?php _e('Facebook URL:', 'wellthemes') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'facebook_url' ); ?>" name="<?php echo $this->get_field_name( 'facebook_url' ); ?>" value="<?php echo $instance['facebook_url']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('gplus_title'); ?>"><?php _e('Google+ Title:', 'wellthemes') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('gplus_title'); ?>" name="<?php echo $this->get_field_name('gplus_title'); ?>" type="text" value="<?php echo $instance['gplus_title']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'gplus_url' ); ?>"><?php _e('Google+ URL:', 'wellthemes') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'gplus_url' ); ?>" name="<?php echo $this->get_field_name( 'gplus_url' ); ?>" value="<?php echo $instance['gplus_url']; ?>" />
		</p>

		
		<p>
			<label for="<?php echo $this->get_field_id('youtube_title'); ?>"><?php _e('Youtube Title:', 'wellthemes') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('youtube_title'); ?>" name="<?php echo $this->get_field_name('youtube_title'); ?>" type="text" value="<?php echo $instance['youtube_title']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'youtube_url' ); ?>"><?php _e('Youtube URL:', 'wellthemes') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'youtube_url' ); ?>" name="<?php echo $this->get_field_name( 'youtube_url' ); ?>" value="<?php echo $instance['youtube_url']; ?>" />
		</p>		
		
		<p>
			<label for="<?php echo $this->get_field_id('rss_title'); ?>"><?php _e('RSS Title:', 'wellthemes') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('rss_title'); ?>" name="<?php echo $this->get_field_name('rss_title'); ?>" type="text" value="<?php echo $instance['rss_title']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'rss_url' ); ?>"><?php _e('RSS URL:', 'wellthemes') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'rss_url' ); ?>" name="<?php echo $this->get_field_name( 'rss_url' ); ?>" value="<?php echo $instance['rss_url']; ?>" />
		</p>
		
		
	<?php
	}
}
?>